<?php
namespace stats;
use \PDO;
use \DateTime;

class AverageBuzzwordsScore {
    private $db;
    private $table;
    private $leapYears = [2020, 2016, 2012, 2008, 2004, 2000, 1996];
    private $months = ['January' => 1, 'February' => 2, 'March' => 3, 'April' => 4, 'May' => 5, 'June' => 6, 'July' => 7, 'August' => 8, 'September' => 9, 'October' => 10, 'November' => 11, 'December' => 12];
    private $beginning;
	private $beginningYear;
    private $end;
    private $thirtyOne = ['January', 'March', 'May', 'July', 'August', 'October', 'December'];
    private $name;
	private $postsStatsTable;
	private $commentsStatsTable;
	private $subCommentsStatsTable;
    private $postsColumn;
	private $commentsColumn;
	private $subCommentsColumn;
	private $scores = [];
    function __construct($db) {
        $this->db = $db;
		
    }
    public function getEndDay($m, $year) {
		if($day = $this->isThisEndMonth($m, $year)) return $day;
        if (in_array($m, $this->thirtyOne)) $endDay = 31;
        elseif ($m == 'February' && !in_array($year, $this->leapYears)) $endDay = 28;
        elseif ($m == 'February') $endDay = 29;
        else $endDay = 30;
        return $endDay;
    }
	private function isThisEndMonth($m, $year){
		$date = new DateTime;
		$date->setTimestamp($this->end);
		$y = (int)$date->format('Y');
		$month = $date->format('F');
		$day = (int)$date->format('d');
		if($m == $month && $year == $y) return $day;
		return false;
	}
    private function continueLoop($timestamp) {
        if ($timestamp < $this->beginning || $timestamp > $this->end) return true;
        return false;
    }
    public function setGroup($group) {
        $this->postsStatsTable = 'group_' . $group . '_posts_stats';
		$this->commentsStatsTable = 'group_' . $group . '_comments_stats';
		$this->subCommentsStatsTable = 'group_' . $group . '_sub_comments_stats';
    }
    public function setName($name) {
        $this->name = $name;
    }
	private function getMetricsMap(){
	    $total = ['postsColumn' => 'postsTotalBuzzwordsScore', 'commentsColumn' => 'commentsTotalBuzzwordsScore', 'subCommentsColumn' => 'subCommentsTotalBuzzwordsScore' ];
		$bp = ['postsColumn' => 'postsBipolarBuzzwordsScore', 'commentsColumn' => 'commentsBipolarBuzzwordsScore', 'subCommentsColumn' => 'subCommentsBipolarBuzzwordsScore' ];
		$sp = ['postsColumn' => 'postsSpecificBuzzwordsScore', 'commentsColumn' => 'commentsSpecificBuzzwordsScore', 'subCommentsColumn' => 'subCommentsSpecificBuzzwordsScore' ];
		$ls = ['postsColumn' => 'postsLessSpecificBuzzwordsScore', 'commentsColumn' => 'commentsLessSpecificBuzzwordsScore', 'subCommentsColumn' => 'subCommentsLessSpecificBuzzwordsScore' ];
		$ns = ['postsColumn' => 'postsNotSpecificBuzzwordsScore', 'commentsColumn' => 'commentsNotSpecificBuzzwordsScore', 'subCommentsColumn' => 'subCommentsNotSpecificBuzzwordsScore' ];
		$array = ['total' => $total, 'bipolar' => $bp, 'specific' => $sp, 'lessSpecific' => $ls, 'notSpecific' => $ns];
		return $array;
	}
	public function setMetric($metric) {
	  foreach($this->getMetricsMap() as $key => $columns) 
		  if($metric == $key) 
			  foreach($columns as $column => $value) $this->$column = $value;
		//print_r($this->postsColumn); newLine(); exit();
    }
    public function setBeginning($beginning) {
        $date = new DateTime;
        $date->setTimestamp($beginning);
        $date->setTime(0,0,0);
        $beginning = $date->getTimestamp();
		$this->beginningYear = (int)$date->format('Y');
        $this->beginning = $beginning;
    }
    public function setEnd($end) {
        $date = new DateTime();
        $date->setTimestamp($end);
        $date->setTime(23, 59, 59);
        $end = $date->getTimestamp();
        $this->end = $end;
    }
    private function clearTable(){
		$sql = 'TRUNCATE `scores_stat`;';
		$stmt = $this->db->query($sql);
	}
	private function getPostsScores() {
		$scores = [];
        $sql = "SELECT $this->postsColumn, postTimestamp FROM $this->postsStatsTable;";
        $stmt = $this->db->query($sql);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
		$var = $this->postsColumn;
		foreach($result as $key => $value) 
			$this->scores[] = (object)['buzzwordsScore' => $value->$var, 'timestamp' => $value->postTimestamp];
		
    }
	 private function getCommentsScores() {
        $sql = "SELECT $this->commentsColumn, commentTimestamp FROM $this->commentsStatsTable;";
        $stmt = $this->db->query($sql);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
		$var = $this->commentsColumn;
		foreach($result as $key => $value) 
			$this->scores[] = (object)['buzzwordsScore' => $value->$var, 'timestamp' => $value->commentTimestamp];
    }
	private function getSubCommentsScores() {
        $sql = "SELECT $this->subCommentsColumn, subCommentTimestamp FROM $this->subCommentsStatsTable;";
        $stmt = $this->db->query($sql);
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
		$var = $this->subCommentsColumn;
		foreach($result as $key => $value) 
			$this->scores[] = (object)['buzzwordsScore' => $value->$var, 'timestamp' => $value->subCommentTimestamp];
    }
	private function initializeScores(){
		$this->getPostsScores();
		$this->getCommentsScores();
		$this->getSubCommentsScores();
	}
    private function getScore($end) {
	 $score = 0;
	 foreach($this->scores as $key => $value)
		 if($value->timestamp <= $end && $value->timestamp >= $this->beginning)
			 $score += $value->buzzwordsScore;
	 
		return $score;		 
    }

    public function getDailyScoes() {
		$this->clearTable();
		$this->initializeScores();
        $date = new \DateTime();
        $date->setTimezone(new \DateTimeZone('US/Eastern'));
        $thisYear = (int)$date->format('Y');
		$i = 1;
        for ($year = $this->beginningYear; $year <= $thisYear; $year++) {
            foreach ($this->months as $m => $month) {
                $endDay = $this->getEndDay($m, $year);
                for ($day = 1;$day <= $endDay;$day++) {
                    $date->setDate($year, $month, $day);
                    $date->setTime(23, 59, 59);
                    $end = $date->getTimestamp();
                    if ($this->continueLoop($end)) continue 1;
                    $score = $this->getScore($end);
                    $sql = "INSERT INTO scores_stat (statId, `month`,`year`,stat,`table`,monthNumber,day) VALUES ($i,'$m',$year,$score,'$this->name',$month,$day)";
                    if($this->db->query($sql)) $i++;
					
                }
            }
        }
    }
    public function getMonthlyScores() {
		$this->clearTable();
		$this->initializeScores();
        $date = new \DateTime();
        $date->setTimezone(new \DateTimeZone('US/Eastern'));
        $thisYear = (int)$date->format('Y');
		$i = 1;
        for ($year = 2000;$year <= $thisYear;$year++) {
            foreach ($this->months as $m => $month) { 
				$day = $this->getEndDay($m, $year);
                $date->setDate($year, $month, $day);
                $date->setTime(23, 59, 59);
                $end = $date->getTimestamp();
                if ($this->continueLoop($end)){ continue 1;}
                $score = $this->getScore($end);
                $sql = "INSERT INTO scores_stat (statId,`month`,`year`,stat,`table`,monthNumber,day) VALUES ($i,'$m',$year,$score,'$this->name',$month,$day)";
                if($this->db->query($sql)) $i++;
				
            }
        }
    }
}
