<?php
namespace stats;
use \PDO;
use \DateTime;

class AverageJoinRatePerDay {
    private $records;
    private $table;
    private $leapYears = [2028, 2024, 2020, 2016, 2012, 2008, 2004, 2000, 1996];
    private $months = ['January' => 1, 'February' => 2, 'March' => 3, 'April' => 4, 'May' => 5, 'June' => 6, 'July' => 7, 'August' => 8, 'September' => 9, 'October' => 10, 'November' => 11, 'December' => 12];
    private $beginning;
    private $end;
    private $thirtyOne = ['January', 'March', 'May', 'July', 'August', 'October', 'December'];
    private $stats;
    function __construct($records, $stats) {
        $this->records = $records;
		$this->stats = $stats;
    }
	public function getStats(){
		$this->getJoinedPerPeriod();
		return $this->stats;
	}
	public function updateStats(){
		foreach($this->getStats() as $key => $stat)
			$this->records->updateJoinedPerDay($stat);
	}
	public function getJoinedPerPeriod(){
		foreach($this->stats as $key => $value)
			$this->stats[$key]->joinedInPeriod = $this->calculateJoinedInPeriod($key);
	}
	public function calculateJoinedInPeriod($index){
		if(!$index) return $this->stats[$index]->stat;
		return ($this->stats[$index]->stat) - ($this->stats[$index - 1]->stat);
	}
   
}
