<?php
namespace stats;
use \PDO;
use \DateTime;

class AverageJoinRatePerMonth {
    private $records;
    private $table;
    private $leapYears = [2028, 2024, 2020, 2016, 2012, 2008, 2004, 2000, 1996];
    private $months = ['January' => 1, 'February' => 2, 'March' => 3, 'April' => 4, 'May' => 5, 'June' => 6, 'July' => 7, 'August' => 8, 'September' => 9, 'October' => 10, 'November' => 11, 'December' => 12];
    private $beginning;
    private $end;
    private $thirtyOne = ['January', 'March', 'May', 'July', 'August', 'October', 'December'];
    private $stats;
    function __construct($records, $stats) {
        $this->records = $records;
		$this->stats = $stats;
    }
	public function getStats(){
		$this->getJoinedPerPeriod();
		$this->setAdjJoined();
		return $this->stats;
	}
	public function updateStats(){
		foreach($this->getStats() as $key => $stat)
			$this->records->updateJoinedPerMonth($stat);
	}
	public function getJoinedPerPeriod(){
		foreach($this->stats as $key => $value)
			$this->stats[$key]->joinedInPeriod = $this->calculateJoinedInPeriod($key);
	}
	public function calculateJoinedInPeriod($index){
		if(!$index) return $this->stats[$index]->stat;
		return $this->stats[$index]->stat - $this->stats[$index - 1]->stat;
	}
	public function setAdjJoined(){
		$this->initializeAdjJoined();
		$this->setFirstMonthAdjJoined();
		$this->setLastMonthAdjJoined();
	}
	public function initializeAdjJoined(){
		foreach($this->stats as $key => $value)
			$this->stats[$key]->adjJoinedInPeriod = $value->joinedInPeriod;
	}
	public function setFirstMonthAdjJoined(){
		$totalDays = $this->getTotalDaysInFirstMonth();
		$daysInFirstMonth = $totalDays - ($this->beginning->format('d'));
		$this->stats[0]->adjJoinedInPeriod = floor($this->stats[0]->joinedInPeriod * ($totalDays/$daysInFirstMonth));
	}
	public function setLastMonthAdjJoined(){
		$joinedInLastMonth = $this->stats[count($this->stats)-1]->joinedInPeriod;
		$totalDays = $this->getTotalDaysInLastMonth();
		$lastDay = $this->getLastPeriodFraction();
		$this->stats[count($this->stats)-1]->adjJoinedInPeriod = ceil($joinedInLastMonth * ($totalDays/$lastDay));
	}
	public function setBeginning($beginning) {
        $date = new DateTime();
        $date->setTimestamp($beginning);
        $date->setTime(0,0,0);
        $this->beginning = $date;
    }
    public function setEnd($end) {
        $date = new DateTime();
        $date->setTimestamp($end);
        $this->end = $date;
    }
	private function getLastPeriodFraction(){
		$lastDay =  $this->end->format('d');
		$hours = $this->end->format('H');
    if($this->end->format('i') > 0)
		$hours += (60/$this->end->format('i'));
		return ($lastDay - 1) + ($hours/24);
		
	}
    public function getEndDay($m, $year) {
        if (in_array($m, $this->thirtyOne)) $endDay = 31;
        elseif ($m == 'February' && !in_array($year, $this->leapYears)) $endDay = 28;
        elseif ($m == 'February') $endDay = 29;
        else $endDay = 30;
        return $endDay;
    }
	private function getTotalDaysInFirstMonth(){
	return $this->getEndDay($this->stats[0]->month, $this->stats[0]->year);
	}
	private function getTotalDaysInLastMonth(){
		$index = count($this->stats);
		$index--;
	return $this->getEndDay($this->stats[$index]->month, $this->stats[$index]->year);
	}
	
 

   
}
