<?php
namespace stats;
use \PDO;
use \DateTime;

class AverageJoinRatePerPeriod {
    private $records;
    private $rate;
    private $beginning;
    private $end;
    private $stats;
    function __construct($records) {
        $this->records = $records;
		$this->stats = $this->records->getSampleStats();
    }
	public function update(){
		$this->initialize();
		$this->rate->updateStats();
	}
	public function setBeginning($beginning) {
        $date = new DateTime;
        $date->setTimestamp($beginning);
        $date->setTime(0,0,0);
        $beginning = $date->getTimestamp();
        $this->beginning = $beginning;
    }
    public function setEnd($end) {
        $date = new DateTime;
        $date->setTimestamp($end);
        $end = $date->getTimestamp();
        $this->end = $end;
    }
	private function initialize(){
		if($this->getJoinRateType() == 'daily') $this->rate = new AverageJoinRatePerDay($this->records, $this->stats);
		else $this->rate = $this->constructAverageJoinRatePerMonth();	
	}
	private function getJoinRateType(){
		$type = new AverageJoinRateType($this->stats);
		return $type->getJoinRateType();
	}
	private function constructAverageJoinRatePerMonth(){
		$rate = new AverageJoinRatePerMonth($this->records, $this->stats);
		$rate->setBeginning($this->beginning);
		$rate->setEnd($this->end);
		return $rate;
	}

}
