<?php
namespace stats;
use \PDO;
use \DateTime;
class AverageJoinRateStats {
    private $db;
    private $table;
    private $leapYears = [2020, 2016, 2012, 2008, 2004, 2000, 1996];
    private $months = ['January' => 1, 'February' => 2, 'March' => 3, 'April' => 4, 'May' => 5, 'June' => 6, 'July' => 7, 'August' => 8, 'September' => 9, 'October' => 10, 'November' => 11, 'December' => 12];
    private $beginning;
	private $beginningYear;
    private $end;
    private $thirtyOne = ['January', 'March', 'May', 'July', 'August', 'October', 'December'];
    private $name;
    function __construct($db) {
        $this->db = $db;
    }
    public function getEndDay($m, $year) {
		if($day = $this->isThisEndMonth($m, $year)) return $day;
        if (in_array($m, $this->thirtyOne)) $endDay = 31;
        elseif ($m == 'February' && !in_array($year, $this->leapYears)) $endDay = 28;
        elseif ($m == 'February') $endDay = 29;
        else $endDay = 30;
        return $endDay;
    }
	private function isThisEndMonth($m, $year){
		$date = new DateTime;
		$date->setTimestamp($this->end);
		$y = (int)$date->format('Y');
		$month = $date->format('F');
		$day = (int)$date->format('d');
		if($m == $month && $year == $y) return $day;
		return false;
	}
    private function continueLoop($timestamp) {
        if ($timestamp < $this->beginning || $timestamp > $this->end)
        if ($timestamp < $this->beginning || $timestamp > $this->end) return true;
        return false;
    }
    public function setTable($table) {
        $this->table = $table;
    }
    public function setName($name) {
        $this->name = $name;
    }
    public function setBeginning($beginning) {
        $date = new DateTime;
        $date->setTimestamp($beginning);
        $date->setTime(0,0,0);
        $beginning = $date->getTimestamp();
		$this->beginningYear = (int)$date->format('Y');
        $this->beginning = $beginning;
    }
    public function setEnd($end) {
        $date = new DateTime;
        $date->setTimestamp($end);
        $date->setTime(23, 59, 59);
        $end = $date->getTimestamp();
        $this->end = $end;
    }
    private function getScore($end) {
        $sql = "SELECT userId FROM $this->table WHERE startTime >= :begin AND startTime <= :end";
        $stmt = $this->db->prepare($sql);
        $stmt->bindParam(":end",$end);
        $stmt->bindParam(":begin",$this->beginning);
        $stmt->execute();
        $score = count($stmt->fetchAll(PDO::FETCH_ASSOC));
        if (!$score) return 0;
        return $score;
    }
       private function getSql($end) {
        $sql = "SELECT userId FROM $this->table WHERE startTime >= $this->beginning AND startTime <= $end";
        return $sql;
    }
	private function clearTable(){
		$sql = 'TRUNCATE `sample_stat`;';
		$stmt = $this->db->query($sql);
	}
    public function getDailyJoinRate() {
		$this->clearTable();
        $date = new DateTime;
        $date->setTimezone(new \DateTimeZone('US/Eastern'));
       
        $thisYear = (int)$date->format('Y');
        for ($year = 2000;$year <= $thisYear;$year++) {
            foreach ($this->months as $m => $month) {
                $endDay = $this->getEndDay($m, $year);
                for ($day = 1;$day <= $endDay;$day++) {
                    
                    $date->setDate($year, $month, $day);
                    $date->setTime(23, 59, 59);
                    $end = $date->getTimestamp();
                    if ($this->continueLoop($end)) continue;
                    $score = $this->getScore($end);
        
                    $sql = "INSERT INTO sample_stat (`month`,`year`,stat,`table`,monthNumber,day) VALUES ('$m',$year,$score,'$this->name',$month,$day)";
                    $stmt = $this->db->query($sql);
                }
            }
        }
    }
    public function getMonthlyJoinRate() {
		$this->clearTable();
        $date = new \DateTime();
        $thisYear = (int)$date->format('Y');
        for ($year = $this->beginningYear; $year <= $thisYear;$year++) {
            foreach ($this->months as $m => $month) { 
				$day = $this->getEndDay($m, $year);
                $date->setDate($year, $month, $day);
                $date->setTime(23, 59, 59);
                $date->setTimezone(new \DateTimeZone('US/Eastern'));
                $end = $date->getTimestamp();
                
                if ($this->continueLoop($end)){ continue 1;}
                $score = $this->getScore($end);
                $sql = "INSERT INTO sample_stat (`month`,`year`,stat,`table`,monthNumber,day) VALUES ('$m',$year,$score,'$this->name',$month,$day)";
                $stmt = $this->db->query($sql);
            }
        }
    }
}
