<?php
namespace stats;
use \PDO;
use \DateTime;

class AverageJoinRateType {
    private $stats;
    function __construct($stats) {
		$this->stats = $stats;
    }
	public function getJoinRateType(){
		if($this->isDaily()) return 'daily';
		return 'monthly';
	}
	private function getNumYears(){
		$count = count($this->stats);
		$firstYear = $this->stats[0]->year;
		$lastYear = $this->stats[$count - 1]->year;
		return $lastYear - $firstYear + 1;
	}
	private function getNumMonths(){
		$count = count($this->stats);
		$firstMonth = $this->stats[0]->monthNumber;
		$lastMonth = $this->stats[$count - 1]->monthNumber;
		return $lastMonth - $firstMonth + 1;
	}
	private function isDaily(){
		$count = count($this->stats);
		$numYears = $this->getNumYears();
		if($numYears == 1 && ($count > ($this->getNumMonths()))) return true;
		if($numYears > 1  && $count > (($numYears * 12))) return true;
		return false;
	}
   
}
