<?php
namespace stats;
use \PDO;
use \DateTime;
class AveragePrimaryScore {
    private $db;
    private $table;
    private $leapYears = [2020, 2016, 2012, 2008, 2004, 2000, 1996];
    private $months = ['January' => 1, 'February' => 2, 'March' => 3, 'April' => 4, 'May' => 5, 'June' => 6, 'July' => 7, 'August' => 8, 'September' => 9, 'October' => 10, 'November' => 11, 'December' => 12];
    private $beginning;
    private $end;
    private $thirtyOne = ['January', 'March', 'May', 'July', 'August', 'October', 'December'];
    private $name;
    function __construct($db) {
        $this->db = $db;
    }
    public function getEndDay($m, $year) {
        if (in_array($m, $this->thirtyOne)) $endDay = 31;
        elseif ($m == 'February' && !in_array($year, $this->leapYears)) $endDay = 28;
        elseif ($m == 'February') $endDay = 29;
        else $endDay = 30;
        return $endDay;
    }
	private function clearTable(){
		$sql = 'TRUNCATE `sample_stat`;';
		$stmt = $this->db->query($sql);
	}
    public function getDailyJoinRate() {
		$this->clearTable();
        $date = new \DateTime();
        $thisYear = (int)$date->format('Y');
        for ($year = 2000;$year < $thisYear;$year++) {
            foreach ($this->months as $m => $month) {
                $endDay = $this->getEndDay($m, $year);
                for ($day = 1;$day <= $endDay;$day++) {
                    $date->setDate($year, $month, $day);
                    $date->setTime(23, 59, 59);
                    $end = $date->getTimestamp();
                    if ($this->continueLoop($end)) continue 1;
                    $score = $this->getScore($end);
                    $sql = "INSERT INTO sample_stat (`month`,`year`,stat,`table`,monthNumber,day) VALUES ('$m',$year,$score,'$this->name',$month,$day)";
                    $stmt = $this->db->query($sql);
                }
            }
        }
    }
    public function getMonthlyJoinRate() {
		$this->clearTable();
        $date = new \DateTime();
        $thisYear = (int)$date->format('Y');
        for ($year = 2000;$year <= $thisYear;$year++) {
            foreach ($this->months as $m => $month) { 
				$day = $this->getEndDay($m, $year);
                $date->setDate($year, $month, $day);
                $date->setTime(23, 59, 59);
                $end = $date->getTimestamp();
                if ($this->continueLoop($end)){ continue 1;}
                $score = $this->getScore($end);
                $sql = "INSERT INTO sample_stat (`month`,`year`,stat,`table`,monthNumber,day) VALUES ('$m',$year,$score,'$this->name',$month,$day)";
                $stmt = $this->db->query($sql);
            }
        }
    }
}
