<?php
namespace stats;
use \PDO;
use \DateTime;
class BuzzwordsScore {
    private $groupNumber;
    private $group;
    private $statsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $db;
	private $specificToMeMultiplier = 1;
    function __construct($db, $groupNumber) {
        $this->db = $db;
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->statsTable = $this->group . '_posts_stats';
        $this->postsTable = $this->group . '_post_scores';
        $this->commentsTable = $this->group . '_comment_scores';
        $this->subCommentsTable = $this->group . '_sub_comment_scores';
    }
    
    private function getIffyScore($value){
        if(isset($value['iffy']) && $value['iffy'] == 1) $iffy = true;
            else $iffy = false;
            if($iffy) $buzzwordCount = $value['aboutMentalHealth'];
    }
	public function setSpecificToMeMultiplier($num){
		if(is_int($num) && $num > 0)
		$this->specificToMeMultiplier = $num;
	}
    public function getPostScores($scores) {
        $array = [];
        foreach ($scores->getPostScores() as $key => $value) {
            $vars = ['postId', 'relevantToAutism', 'relevantToMentalHealth', 'buzzwordCount', 'specificToMe'];
            foreach ($vars as $var) ${$var} = $value[$var];
            $score = $relevantToMentalHealth - $relevantToAutism;
            if($specificToMe)
			      $score = $score * $this->specificToMeMultiplier;
            $totalScore = $score * $buzzwordCount;
            $array[] = (object)['postId' => $postId, 'totalScore' => $totalScore];
        }
        return $array;
    }
    public function getCommentScores($scores) {
        $array = [];
        foreach ($scores->getCommentScores() as $key => $value) {
            $vars = ['commentId', 'relevantToAutism', 'relevantToMentalHealth', 'buzzwordCount','specificToMe'];
            foreach ($vars as $var) ${$var} = $value[$var];
            $score = $relevantToMentalHealth - $relevantToAutism;
            if($specificToMe)
              $score = $score * $this->specificToMeMultiplier;
            $totalScore = $score * $buzzwordCount;
            $array[] = (object)['commentId' => $commentId, 'totalScore' => $totalScore];
        }
        return $array;
    }
    public function getSubCommentScores($scores) {
        $array = [];
        foreach ($scores->getSubCommentScores() as $key => $value) {
            $vars = ['subCommentId', 'relevantToAutism', 'relevantToMentalHealth', 'buzzwordCount','specificToMe'];
            foreach ($vars as $var) ${$var} = $value[$var];
            $score = $relevantToMentalHealth - $relevantToAutism;
            if($specificToMe)
            $score = $score * $this->specificToMeMultiplier;
            $totalScore = $score * $buzzwordCount;
            $array[] = (object)['subCommentId' => $subCommentId, 'totalScore' => $totalScore];
        }
        return $array;
    }
}
