<?php
namespace stats;
use \PDO;
use \DateTime;
use \extractors\PureText;
use \extractors\AnalysisText;
class SourceStats {
    private $db;
    private $groupNumber;
    private $postsStatsTable;
    private $commentsStatsTable;
    private $subCommentsStatsTable;
    private $postComponentsTable;
    private $post;
    private $usersStatsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $usersTable;
    private $directory;
    private $postsData;
    private $postComponentsData;
    private $commentsData;
    private $subCommentsData;
    private $statsData;
    private $subCommentsArrayData;
    private $commentsArrayData;
    private $commentsArrayFile;
    private $subCommentsArrayFile;
   function __construct($db, $groupNumber) {
        $this->db = $db;
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->directory = getenv('BASE_URI') . '/data-cache';
        $this->commentsArrayFile = $this->group . "_comments_array.txt";
        $this->subCommentsArrayFile = $this->group . "_sub_comments_array.txt";
        $this->loadData();
    }
    private function loadData(){
        $this->loadCommentsArrayData();
        $this->loadSubCommentsArrayData();
    }
    public function loadCommentsArrayData(){
        $this->commentsArrayData = json_decode(file_get_contents($this->directory."/$this->commentsArrayFile.txt"),true);
    }
    public function loadSubCommentsArrayData(){
        $this->subCommentsArrayData = json_decode(file_get_contents($this->directory."/$this->subCommentsArrayFile.txt"),true);
    }
    public function getCommentsArrayData(){
        return $this->commentsArrayData;
    }
    public function getSubCommentsArrayData(){
        return $this->subCommentsArrayData;
    }
    public function imageOnlyCommentsByUserId($userId){
        $count = 0;
        foreach($this->commentsData as $k => $value) if($value['altUserId'] == $userId) $count++;
        return $count;
    }
    public function imageOnlySubCommentsByUserId($userId){
        $count = 0;
        foreach($this->subCommentsData as $k => $value) if($value['altUserId'] == $userId) $count++;
        return $count;
    }
}
