<?php
namespace stats;
use \PDO;
use \DateTime;
class CommentsCache {
    private $db;
    private $groupNumber;
    private $postsStatsTable;
    private $commentsStatsTable;
    private $subCommentsStatsTable;
    private $postComponentsTable;
    private $post;
    private $usersStatsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $directory = 'data-cache';
    private $statsData;
   function __construct($groupNumber) {
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->usersStatsTable = $this->group . '_users_stats';
        $this->postsStatsTable = $this->group . '_posts_stats';
        $this->commentsStatsTable = $this->group . '_comments_stats';
        $this->commentsTable = $this->group . '_comments';
        $this->subCommentsStatsTable = $this->group . '_sub_comments_stats';
        $this->postComponentsTable = $this->group . '_post_components';
        $this->directory = getenv('BASE_URI') . '/data-cache'; 
        $this->loadData();
    }
    private function loadData(){
        $this->commentsData = json_decode(file_get_contents($this->directory."/$this->commentsTable.txt"));
    }
    public function commentsDataByPostId($postId){
        $count = 0;
         $comments = [];
         $comments[$postId] = [];
        foreach($this->commentsData as $key => $value) 
        if($value->postId==$postId) $comments[$postId][] = (object)['commentMessage' => $value->commentMessage, 'commentId' => $value->commentId, 'userId' => $value->userId];
        return $comments;
    }
    public function commentsByPostId($postId){
        $count = 0;
         $comments = [];
         ///$comments[$postId] = [];
        foreach($this->commentsData as $key => $value) 
        if($value->postId == $postId && $value->processed == 0 && $value->emptyComment == 0) $comments[] = (object)['commentMessage' => $value->commentMessage, 'commentId' => $value->commentId, 'userId' => $value->userId];
        return $comments;
    }
    public function postIdsInComments($processed = 0){
        $count = 0;
        $comments = [];
        foreach($this->commentsData as $key => $value) 
        if($value->emptyComment == 0 && $value->processed == $processed) $comments[] =  $value->postId;
        $comments = array_unique($comments);
        return $comments;
    }
    public function commentCountByUserId($userId){
        $count = 0;
        foreach($this->statsData as $key => $value) 
            if($value['altUserId'] == $userId) $count++;
        return $count;
    }
    public function commentCountByPostAndUserId($postId,$userId){
        $count = 0;
        foreach($this->statsData as $key => $value) 
            if($value['postId']==$postId && $value['altUserId'] == $userId) $count++;
        return $count;
    }
    public function didUserComment($postId,$userId){
        foreach($this->statsData as $key => $value) 
            if($value['postId']==$postId && $value['altUserId'] == $userId) return 1;
    }
     public function totalByUserId($userId, $itemToGet){
        $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['altUserId'] == $userId) $count += $value[$itemToGet];
        return $count;
    }
}
