<?php
namespace stats;
use \PDO;
use \DateTime;
class CommentsStats {
    private $db;
    private $groupNumber;
    private $postsStatsTable;
    private $commentsStatsTable;
    private $subCommentsStatsTable;
    private $postComponentsTable;
    private $post;
    private $usersStatsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $directory = 'data-cache';
    private $statsData;
	private $group;
   function __construct($groupNumber) {
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->usersStatsTable = $this->group . '_users_stats';
        $this->postsStatsTable = $this->group . '_posts_stats';
        $this->commentsStatsTable = $this->group . '_comments_stats';
        $this->subCommentsStatsTable = $this->group . '_sub_comments_stats';
        $this->postComponentsTable = $this->group . '_post_components';
        $this->directory = getenv('BASE_URI') . '/data-cache'; 
        $this->loadData();
    }
    private function loadData(){
        $this->statsData = json_decode(file_get_contents($this->directory."/$this->commentsStatsTable.txt"),true);
    }
    public function commentCountByPostId($postId){
        $count = 0;
        foreach($this->statsData as $key => $value) if($value['postId']==$postId) $count++;
        return $count;
    }
    public function commentCountByUserId($userId){
        $count = 0;
        foreach($this->statsData as $key => $value) 
            if($value['altUserId'] == $userId) $count++;
        return $count;
    }
    public function commentCountByPostAndUserId($postId,$userId){
        $count = 0;
        foreach($this->statsData as $key => $value) 
            if($value['postId']==$postId && $value['altUserId'] == $userId) $count++;
        return $count;
    }
    public function didUserComment($postId,$userId){
        foreach($this->statsData as $key => $value) 
            if($value['postId']==$postId && $value['altUserId'] == $userId) return 1;
    }
     public function totalByUserId($userId, $itemToGet){
        $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['altUserId'] == $userId) $count += $value[$itemToGet];
        return $count;
    }
	  public function commentUserIdsByPostId($postId){
		  $array = [];
        foreach($this->statsData as $key => $value) 
            if($value['postId']==$postId && !in_array($value['altUserId'],$array)) $array[] = $value['altUserId'];
		  return $array;
    }
 
    
	
}
