<?php
namespace stats;
use \PDO;
use \DateTime;
class FirstActivity{
    private $groupNumber;
    private $group;
    private $statsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $db;
    function __construct($db, $groupNumber) {
        $this->db = $db;
		$this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->statsTable = $this->group . '_users_stats';
        $this->postsTable = $this->group . '_posts';
        $this->commentsTable = $this->group . '_comments';
        $this->subCommentsTable = $this->group . '_sub_comments';
    }
    public function getFirstPost($begin = false, $end = false) {
        $result = $this->getFirstPostSelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
			if($begin && $end)
			if($userId < $begin || $userId > $end) continue;
            $sql = "SELECT MIN(postTimestamp) FROM $this->postsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
			$result = $stmt->fetchAll(PDO::FETCH_ASSOC)[0]['MIN(postTimestamp)'];
			if (!empty($result)){
            $sql = "UPDATE $this->statsTable SET firstPost = $result WHERE userId = $userId";
            $stmt = $this->db->query($sql);
        }
		}
		
    }
	   public function getFirstComment($begin = false, $end = false) {
        $result = $this->getFirstCommentSelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
			if($begin && $end)
			if($userId < $begin || $userId > $end) continue;
            $sql = "SELECT MIN(commentTimestamp) FROM $this->commentsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
			$result = $stmt->fetchAll(PDO::FETCH_ASSOC)[0]['MIN(commentTimestamp)'];
            if (!empty($result)){
            $sql = "UPDATE $this->statsTable SET firstComment = $result WHERE userId = $userId";
            $stmt = $this->db->query($sql);
			}
        }
	   }
		public function getFirstSubComment($begin = false, $end = false) {
        $result = $this->getFirstSubCommentSelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
			if($begin && $end)
			if($userId < $begin || $userId > $end) continue;
            $sql = "SELECT MIN(subCommentTimestamp) FROM $this->subCommentsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
			$result = $stmt->fetchAll(PDO::FETCH_ASSOC)[0]['MIN(subCommentTimestamp)'];
             if (!empty($result)){
				$stamp = $result;
            $sql = "UPDATE $this->statsTable SET firstSubComment = $stamp WHERE userId = $userId";
            $stmt = $this->db->query($sql);
			 }
        }
    }
    public function getFirstPostSelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `firstPost` = 0 AND userPostCount  > 0";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
	 public function getFirstCommentSelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `firstComment` = 0 AND userCommentCount > 0";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
	 public function getFirstSubCommentSelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `firstSubComment` = 0 AND userSubCommentCount > 0";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getLastActivitySelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `lastActivity` = 0 AND (userPostCount > 0 || userCommentCount > 0 || userSubCommentCount > 0)";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
