<?php
namespace stats;
use \PDO;
use \DateTime;
class FirstAndLastActivity {
    private $groupNumber;
    private $group;
    private $statsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $db;
    function __construct($db, $groupNumber) {
        $this->db = $db;
		$this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->statsTable = $this->group . '_users_stats';
        $this->postsTable = $this->group . '_posts';
        $this->commentsTable = $this->group . '_comments';
        $this->subCommentsTable = $this->group . '_sub_comments';
    }
	public function alt($begin = false, $end = false){
		 $result = $this->getFirstActivitySelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
		$sql = "SELECT MIN(postTimestamp), MIN(commentTimestamp), MIN(subCommentTimestamp) 
		FROM $this->postsTable
		JOIN $this->commentsTable ON $this->postsTable.altUserId = $this->commentsTable.altUserId
		JOIN $this->subCommentsTable ON $this->subCommentsTable.altUserId = $this->commentsTable.commentId WHERE $this->postsTable.altUserId = $userId";
		 $stmt = $this->db->query($sql);
            if ($stmt->rowCount()){
				$result = $stmt->fetchAll(\PDO::FETCH_ASSOC)[0];
				if(!empty($result['MIN(postTimestamp)']))
				$stamps[] = $result['MIN(postTimestamp)'];
				if(!empty($result['MIN(commentTimestamp)']))
				$stamps[] = $result['MIN(commentTimestamp)'];
				if(!empty($result['MIN(subCommentTimestamp)']))
				$stamps[] = $result['MIN(subCommentTimestamp)'];
				if (!empty($stamps)) $min = min($stamps);
                else $min = 0;
				$sql = "UPDATE $this->statsTable SET firstActivity = $min WHERE userId = $userId";
                $stmt = $this->db->query($sql);
			} 
		 else continue;
		
		
		}
	}
    public function getFirstActivity($begin = false, $end = false) {
        $result = $this->getFirstActivitySelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
			if($begin && $end)
			if($userId < $begin || $userId > $end) continue;
            $sql = "SELECT MIN(postTimestamp) FROM $this->postsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
            if ($stmt->rowCount()) $stamp = $stmt->fetchAll(PDO::FETCH_ASSOC) [0]['MIN(postTimestamp)'];
            if (!empty($stamp)) $stamps[] = $stamp;
            $sql = "SELECT MIN(commentTimestamp) FROM $this->commentsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
            if ($stmt->rowCount()) $stamp = $stmt->fetchAll(PDO::FETCH_ASSOC) [0]['MIN(commentTimestamp)'];
            if (!empty($stamp)) $stamps[] = $stamp;
            $sql = "SELECT MIN(subCommentTimestamp) FROM $this->subCommentsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
            if ($stmt->rowCount()) $stamp = $stmt->fetchAll(PDO::FETCH_ASSOC) [0]['MIN(subCommentTimestamp)'];
            if (!empty($stamp)) $stamps[] = $stamp;
            if (!empty($stamps)) $min = min($stamps);
            else $min = 0;
            $sql = "UPDATE $this->statsTable SET firstActivity = $min WHERE userId = $userId";
            $stmt = $this->db->query($sql);
        }
    }
    public function getLastActivity($begin = false, $end = false) {
        $result = $this->getLastActivitySelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
			if($begin && $end)
			if($userId < $begin || $userId > $end) continue;
            $sql = "SELECT MAX(postTimestamp) FROM $this->postsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
            if ($stmt->rowCount()) $stamp = $stmt->fetchAll(PDO::FETCH_ASSOC) [0]['MIN(postTimestamp)'];
            if (!empty($stamp)) $stamps[] = $stamp;
            $sql = "SELECT MAX(commentTimestamp) FROM $this->commentsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
            if ($stmt->rowCount()) $stamp = $stmt->fetchAll(PDO::FETCH_ASSOC) [0]['MIN(commentTimestamp)'];
            if (!empty($stamp)) $stamps[] = $stamp;
            $sql = "SELECT MAX(subCommentTimestamp) FROM $this->subCommentsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
            if ($stmt->rowCount()) $stamp = $stmt->fetchAll(PDO::FETCH_ASSOC) [0]['MAX(subCommentTimestamp)'];
            if (!empty($stamp)) $stamps[] = $stamp;
            if (!empty($stamps)) $max = max($stamps);
            else $max = 0;
            $sql = "UPDATE $this->statsTable SET lastActivity = $max WHERE userId = $userId";
            $stmt = $this->db->query($sql);
        }
    }
    public function getFirstActivitySelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `firstActivity` = 0 AND (postCount > 0 || commentCount > 0 || subCommentCount > 0)";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getLastActivitySelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `lastActivity` = 0 AND (postCount > 0 || commentCount > 0 || subCommentCount > 0)";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
