<?php
namespace stats;
use \PDO;
use \DateTime;
class GroupTableUsersRange {
    private $db;
    private $table;
    private $group;
    function __construct($db) {
        $this->db = $db;
    }
	public function setGroup($group){
        $this->group = $group;
		$this->table = "group_".$group."_users_stats";
	}
	public function getTimestampArray(){
		$sql = "SELECT startTime FROM $this->table ORDER BY startTime DESC";
		$stmt = $this->db->query($sql);
		$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
		return $result;
	}
	public function getEarliestUser(){
		$result = $this->getTimestampArray();
		return end($result)['startTime'];
	}
	public function getLatestUser(){
		$result = $this->getTimestampArray();
		return $result[0]['startTime'];
	}
}
