<?php
namespace stats;

class GroupTestStats {
    private $groupNumber;
    private $group;
    private $statsTable;
    private $postsTable;
    private $commentsTable;
    private $client;
    private $db;
    function __construct($client) {
        $this->client = $client;
    }
  
	public function getTestStats($group, $testsArray) {
 
$metrics = $this->client->selectGroupMetrics($group);
$scoresForEras =  [];


  foreach($this->getTestsArrayData($testsArray) as $k => $item){
   
   $this->addToScoresForErasIfNeeded($item, $group, $scoresForEras);
   $this->scoreItems($metrics, $item, $scoresForEras);
   
  
  }
    $this->calculateScoreAverages($scoresForEras);
    return $scoresForEras;
    
    }
  
  private function calculateScoreAverages(&$scoresForEras){
    foreach($scoresForEras as $k => $item){
  $scoresForEras[$k]->scamEraAverage = $scoresForEras[$k]->scamEraScore/$scoresForEras[$k]->scamEraScoreCount;
  $scoresForEras[$k]->preScamEraAverage = $scoresForEras[$k]->preScamEraScore/$scoresForEras[$k]->preScamEraScoreCount;
  }
  }
  private function scoreItems($metrics, $item, &$scoresForEras){
       foreach($metrics as $key => $metric){
        $var = $item->originalName;
         $name = $item->name;
     if(isset($metric->$var)){
      if($item->era == 'scam'){
        
        $scoresForEras[$name]->scamEraScore += $metric->$var;
        
        $scoresForEras[$name]->scamEraScoreCount++;        
        
      }
      else{
        $scoresForEras[$name]->preScamEraScore += $metric->$var;
        
        $scoresForEras[$name]->preScamEraScoreCount++; 
      }
      
     }
   }
  }
  
private function addToScoresForErasIfNeeded($item, $group, &$scoresForEras){
   if(!isset($scoresForEras[$item->name]))
    $scoresForEras[$item->name] = 
    (object)['scamEraScore' => 0, 'scamEraScoreCount' => 0, 'preScamEraScore' => 0, 'preScamEraScoreCount' => 0, 'scamEraAverage' => 0, 'preScamEraAverage' => 0, 'group' => $group, 'name' => $item->name];
}
  
  private function getTestsArrayData($testsArray){
    $testsNames = [];
foreach($testsArray as $key => $test)
   $testsNames[] = $this->buildTestArrayObject($test);
  return $testsNames;
  }

  private function buildTestArrayObject($test){
   $name = $this->getTestName($test);
   $era = $this->getEra($test);
  return (object)['name' => $name, 'originalName' => $test, 'era' => $era];
  }
  
  private function getEra($test){
      if(strpos($test, 'PreScamEra') !== false) $era = 'pre';
  else $era = 'scam';
  return $era;
}
private function getTestName($test){
  $name = str_replace('PreScamEra','',$test);
 return str_replace('ScamEra','',$name);
}

}
