<?php
namespace stats;
use \PDO;
use \DateTime;
class LastActivity {
    private $groupNumber;
    private $group;
    private $statsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $db;
    function __construct($db, $groupNumber) {
        $this->db = $db;
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->statsTable = $this->group . '_users_stats';
        $this->postsTable = $this->group . '_posts';
        $this->commentsTable = $this->group . '_comments';
        $this->subCommentsTable = $this->group . '_sub_comments';
    }
    public function getLastPost($begin = false, $end = false) {
        $result = $this->getLastPostSelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
            if ($begin && $end) if ($userId < $begin || $userId > $end) continue;
            $sql = "SELECT MAX(postTimestamp) FROM $this->postsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
			$result = $stmt->fetchAll(PDO::FETCH_ASSOC)[0]['MAX(postTimestamp)'];
            if (!empty($result)){
				$sql = "UPDATE $this->statsTable SET lastPost = $result WHERE userId = $userId";
            $stmt = $this->db->query($sql);
			}
         
            
        }
    }
    public function getLastComment($begin = false, $end = false) {
        $result = $this->getLastCommentSelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
            if ($begin && $end) if ($userId < $begin || $userId > $end) continue;
            $sql = "SELECT MAX(commentTimestamp) FROM $this->commentsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
			$stamp = $stmt->fetchAll(PDO::FETCH_ASSOC)[0]['MAX(commentTimestamp)'];
            if (!empty($stamp)){
            $sql = "UPDATE $this->statsTable SET lastComment = $stamp WHERE userId = $userId";
            $stmt = $this->db->query($sql);
			}
        }
    }
    public function getLastSubComment($begin = false, $end = false) {
        $result = $this->getLastSubCommentSelection();
        foreach ($result as $key => $value) {
            $stamps = [];
            $userId = $value['userId'];
            if ($begin && $end) if ($userId < $begin || $userId > $end) continue;
            $sql = "SELECT MAX(subCommentTimestamp) FROM $this->subCommentsTable WHERE altUserId = $userId";
            $stmt = $this->db->query($sql);
			$stamp = $stmt->fetchAll(PDO::FETCH_ASSOC)[0]['MAX(subCommentTimestamp)'];
            if(!empty($stamp)){
			  $sql = "UPDATE $this->statsTable SET lastSubComment = $stamp WHERE userId = $userId";
            $stmt = $this->db->query($sql);	
			} 
          
        }
    }
    public function getLastPostSelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `lastPost` = 0 AND userPostCount > 0";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getLastCommentSelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `lastComment` = 0 AND userCommentCount > 0";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getLastSubCommentSelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `lastSubComment` = 0 AND userSubCommentCount > 0";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getLastActivitySelection() {
        $sql = "SELECT userId FROM $this->statsTable WHERE `lastActivity` = 0 AND (userPostCount > 0 || userCommentCount > 0 || subCommentCount > 0)";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
