<?php
namespace stats;
class MetricsDataInsert {
    private $group;
    private $db;
    private $table;
    function __construct($db) {
        $this->db = $db;
    }
    public function setTable($table){
        $this->table = $table;
    }
    private function testMetricsTableForData(){
        $sql = "SELECT metricsAnalysisId FROM $this->table";
        $stmt = $this->db->query($sql);
        if(count($stmt->fetchAll(\PDO::FETCH_ASSOC)) == 0) return false;
        return true;
    }
    private function loadDb($sqlItems){
            $arr = ['period','periodStart','periodEnd','daysInPeriod','usersCount','usersJoinedInPeriod'];
        foreach($sqlItems as $key => $value){
            foreach($arr as $r) ${$r} = $value[$r];
            $sql = "INSERT INTO $this->table (period, periodStart,periodEnd,daysInPeriod,usersCount,usersJoinedInPeriod) VALUES
            (:period, $periodStart, $periodEnd, $daysInPeriod,$usersCount,$usersJoinedInPeriod);";
            $stmt = $this->db->prepare($sql);
            $stmt->execute([":period"=>$period]);    
        } 
    }
    public function truncateTable(){
        $sql = "TRUNCATE $this->table;";
        $this->db->query($sql);
    }
    public function reloadTable($sqlItems){
        $this->truncateTable();
        $this->loadDb($sqlItems);
    }
    public function initMetricsTable($sqlItems){
        if(!$this->testMetricsTableForData()) $this->loadDb($sqlItems);
        else echo("<br>Metrics Table is already loaded<br>");
    }
}
