<?php
namespace stats;

class MetricsDataProcessor {
    private $dataArray;
    private $scamEraQuota;
    private $preScamEraQuota;
    private $breakPeriod;
    private $lastPeriod;
    function __construct($data) {
        $this->dataArray = $data;
    }
    public function setQuotas($pre,$scam){
       $this->preScamEraQuota = $pre;
       $this->scamEraQuota = $scam;    
    }
    private function findBreakPeriod() {
        foreach($this->dataArray as $key => $value)
            if($value['breakPeriod']) $this->breakPeriod = $key;
    }
    private function testBreakPeriod(){
        if($this->dataArray[$this->breakPeriod]['usersJoinedInPeriod'] < $this->preScamEraQuota) return false;
        return true;
    }
    private function testLastPeriod(){
      $this->lastPeriod = count($this->dataArray)-1;
        if($this->dataArray[$this->lastPeriod]['usersJoinedInPeriod'] < $this->scamEraQuota) return false;
        return true;
    }
    private function getPeriod($start, $end){
        $start = explode('-',$start)[0];
        $end = explode('-',$end)[1];
        $period  = "$start - $end";
        return $period;
    }
    private function combineBreakPeriod(){
       $arr = [];
       $vars = ['usersJoinedInPeriod','daysInPeriod'];
        foreach($vars as $var)
            $arr[$var] = $this->dataArray[$this->breakPeriod-1][$var]
            + $this->dataArray[$this->breakPeriod][$var];
        
        $arr['start'] = $this->dataArray[$this->breakPeriod-1]['start'];
        $arr['end'] = $this->dataArray[$this->breakPeriod]['end'];
        $arr['periodStart'] = $this->dataArray[$this->breakPeriod-1]['periodStart'];
        $arr['periodEnd'] = $this->dataArray[$this->breakPeriod]['periodEnd'];
        $arr['period'] = $this->getPeriod($this->dataArray[$this->breakPeriod-1]['period'], $this->dataArray[$this->breakPeriod]['period']);
         $arr['usersCount'] = $this->dataArray[$this->breakPeriod]['usersCount'];
        return $arr;
    }
    private function combineLastPeriod(){
       $arr = [];
       $vars = ['usersJoinedInPeriod','daysInPeriod'];
        foreach($vars as $var)
            $arr[$var] = $this->dataArray[$this->lastPeriod-1][$var]
            + $this->dataArray[$this->lastPeriod][$var];
        
        $arr['start'] = $this->dataArray[$this->lastPeriod-1]['start'];
        $arr['end'] = $this->dataArray[$this->lastPeriod]['end'];
        $arr['periodStart'] = $this->dataArray[$this->lastPeriod-1]['periodStart'];
        $arr['periodEnd'] = $this->dataArray[$this->lastPeriod]['periodEnd'];
        $arr['period'] = $this->getPeriod($this->dataArray[$this->lastPeriod-1]['period'], $this->dataArray[$this->lastPeriod]['period']);
        $arr['usersCount'] = $this->dataArray[$this->lastPeriod]['usersCount'];
        return $arr;
    }
    
    private function getCombinedBreakPeriod($array){
        $arr = [];
         foreach($array as $key => $value){
            if($key == $this->breakPeriod) continue;
            if($key == $this->breakPeriod - 1)
                $arr[] = $this->combineBreakPeriod();
            else $arr[] = $value;
            }
        return $arr;
    }
    private function getCombinedLastPeriod(){
        $arr = [];
        foreach($this->dataArray as $key => $value){
        if($key == $this->lastPeriod) continue;
        if($key == $this->lastPeriod - 1)
        $arr[] = $this->combineLastPeriod();
        else $arr[] = $value;
        }
        return $arr;
    }
    public function getAdjustedData(){
        $arr = []; 
        $this->findBreakPeriod();
        if(!$this->testLastPeriod()) $array = $this->getCombinedLastPeriod();
        else $array = $this->dataArray;
         if(!$this->testBreakPeriod()) return $this->getCombinedBreakPeriod($array);
        else return $array;
    }
}
