<?php
namespace stats;
use \PDO;
use \DateTime;
class MetricsTableData {
    private $db;
    private $table;
    private $group;
    private $usersStats;
    private $dataArray = [];
    private $earliestUser;
    private $latestUser;
    private $cutoff;
    private $scamEraQuota;
    private $preScamEraQuota;
    private $beginningDate;
    private $endingDate;
    function __construct($db, $group, $usersStats) {
        $this->db = $db;
        $this->group = $group;
        $this->usersStats = $usersStats;
        $this->setUsersRange();
    }
    public function setTable($table){
        $this->table = $table;
    }
    private function setUsersRange() {
        $usersRange = new GroupTableUsersRange($this->db);
        $usersRange->setGroup($this->group);
        $begin = new DateTime;
        $begin->setTimestamp($usersRange->getEarliestUser());
        $begin->setTime(0, 0, 0);
        $end = new DateTime;
        $end->setTimestamp($usersRange->getLatestUser());
        $end->setTime(23, 59, 59);
        $this->beginningDate = $begin;
        $this->endingDate = $end;
    }
    private function getQuota($date) {
        if ($date > $this->cutoff) return $this->scamEraQuota;
        else return $this->preScamEraQuota;
    }
    public function setScamEra(\DateTime $start) {
        $start = clone $start;
        $start->sub(new \DateInterval('P1D'));
        $start->setTime(23, 59, 59);
        $this->cutoff = $start;
    }
    public function setQuotas($pre,$scam) {
        $this->preScamEraQuota = $pre;
        $this->scamEraQuota = $scam;
    }
    private function getDaysCount($start, $end) {
        $interval = date_diff($start, $end);
        $i = $interval->format('%a');
        return $i + 1;
    }
    private function getPeriod($start, $end) {
        $periodBeginning = $start->format('M d, Y');
        $periodEnd = $end->format('M d, Y');
        return "$periodBeginning - $periodEnd";
    }
    private function getFirstDate($date) {
        $date = clone $date;
        $date->setTime(0, 0, 0);
        return $date;
    }
    private function getLastDate($beg) {
        $lastDate = clone ($beg);
        $lastDate->setTime(23, 59, 59);
        return $lastDate;
    }
    private function getNextDate($end){
        $end = clone $end;
        $end->setTime(0,0,0);
        $end->add(new \DateInterval('PT1S'));
        return $end;  
    }
    private function addOneDay($beginningDate) {
        $date = clone $beginningDate;
        $date->add(new \DateInterval('P1D'));
        return $date;
    }
    private function adjustEndDate($end){
          $end = $this->addOneDay($end);
          $end = $this->getLastDate($end);
          return $end;
    }
    private function checkForBreak($date) {
        $date = clone $date;
        if ($date == $this->cutoff) return true;
        return false;
    }
    private function getCountForDateRange($start, $end) {
        $start = clone $start;
        $end = clone $end;
        $end->setTime(23, 59, 59);
        $start->setTime(0, 0, 0);
        $beg = $start->getTimestamp();
        $end = $end->getTimestamp();
        return $this->usersStats->usersByTimeInterval($beg, $end);
    }
    private function getCumulativeUsers($end) {
        $count = $this->usersStats->cumulativeUsersByTime($end->getTimestamp());
        return $count;
    }
    private function getSqlItems($start, $end, $count, $breakPeriod) {
        $sqlItems = ['start' => clone $start, 'end' => clone $end, 'usersJoinedInPeriod' => $count, 'usersCount' => $this->getCumulativeUsers($end), 'daysInPeriod' => $this->getDaysCount($start, $end), 'period' => $this->getPeriod($start, $end), 'periodStart' => $start->getTimestamp(), 'periodEnd' => $end->getTimestamp(), 'breakPeriod' => $breakPeriod ];
        $end = $this->addOneDay($end);
        $sqlItems['nextDate'] = clone $end;
        return $sqlItems;
    }
    private function getStartingBlock($beginningDate) {
        $count = 0;
        $start = $this->getFirstDate($beginningDate);
        $end = $this->getLastDate($beginningDate);
        $i = 0;
        while (($count) < $this->getQuota($start) && ($end < $this->endingDate)) {
            if ($i) $end = $this->adjustEndDate($end);
            $count = $this->getCountForDateRange($start, $end);
            if ($breakPeriod = $this->checkForBreak($end)) break;
            $i++;
        }
        return $this->getSqlItems($start, $end, $count, $breakPeriod);
    }
    public function assembleDataArray(){
        $results = [];
        $var = $this->getStartingBlock($this->beginningDate);
        $results[] = $var;
        while(($var['nextDate'] < $this->endingDate)){
        $var = $this->getStartingBlock($this->getNextDate($var['nextDate'])); 
        $results[] = $var;
        }
        return $results;
    }
}
