<?php
namespace stats;
use \PDO;
use \DateTime;
class PostComponentsCache {
    private $db;
    private $groupNumber;
    private $postsStatsTable;
    private $commentsStatsTable;
    private $subCommentsStatsTable;
    private $postComponentsTable;
    private $post;
    private $usersStatsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $directory = 'data-cache';
    private $statsData;
   function __construct($groupNumber) {
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->usersStatsTable = $this->group . '_users_stats';
        $this->postsStatsTable = $this->group . '_posts_stats';
        $this->commentsStatsTable = $this->group . '_comments_stats';
        $this->subCommentsStatsTable = $this->group . '_sub_comments_stats';
        $this->postComponentsTable = $this->group . '_post_components';
        $this->directory = getenv('BASE_URI') . '/data-cache'; 
        $this->loadData();
    }
    private function loadData(){
        $this->statsData = json_decode(file_get_contents($this->directory."/$this->postComponentsTable.txt"),true);
    }
    public function postTextCountByUserId($userId){
        $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['altUserId'] == $userId && $value['category'] == 'text') $count++;
        return $count;
    }
	 public function postsWithText(){
		 $array = [];
        foreach($this->statsData as $key => $value)
            if($value['category'] == 'text') $array[] = (object)$value;
        return $array;
    }
    
	
}
