<?php
namespace stats;
use \PDO;
use \DateTime;
class PostsStats {
    private $db;
    private $groupNumber;
    private $postsStatsTable;
    private $commentsStatsTable;
    private $subCommentsStatsTable;
    private $postComponentsTable;
    private $post;
    private $usersStatsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $directory = 'data-cache';
    private $statsData;
	private $group;
   function __construct($groupNumber) {
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->usersStatsTable = $this->group . '_users_stats';
        $this->postsStatsTable = $this->group . '_posts_stats';
        $this->commentsStatsTable = $this->group . '_comments_stats';
        $this->subCommentsStatsTable = $this->group . '_sub_comments_stats';
        $this->postComponentsTable = $this->group . '_post_components';
        $this->directory = getenv('BASE_URI') . '/data-cache';
        $this->loadData();
    }
    private function loadData(){
        $this->statsData = json_decode(file_get_contents($this->directory."/$this->postsStatsTable.txt"),true);
    }
    
    private function testForAtLeastOneAuthorComment($postId, $userId){
        $commentsStats = new CommentsStats($this->db, $this->groupNumber);
        $subCommentsStats = new SubCommentsStats($this->db, $this->groupNumber);
        if($commentsStats->didUserComment($postId, $userId)) return 1;
        else if($subCommentsStats->didUserComment($postId, $userId)) return 1;
        return 0;
    }
    private function postsWithAtLeastOneAuthorComment($userId, $array){
        $count = 0;
        foreach($array as $postId) $count += $this->testForAtLeastOneAuthorComment($postId, $userId);
        return $count;
    }
    private function hasCommentsToCount($value, $userId){
        if($value['altUserId'] == $userId && $value['actualPostTotalComments'] > 0) return true;
        return false;
    }
    public function totalByUserId($userId, $itemToGet){
        $total = 0;
        $i = 0;
        foreach($this->statsData as $key => $value)
            if($value['altUserId'] == $userId) $total += $value[$itemToGet];
            
        return $total;
    }
    public function postCountByUserId($userId){
        $count = 0;
        foreach($this->statsData as $key => $value) if($value['altUserId']==$userId) $count++;
        return $count;
    }
    public function moreThanOneCommentCount($userId){
        $count = 0;
        foreach($this->statsData as $key => $value)
        if($this->hasCommentsToCount($value, $userId) == true) $count++;
        return $count;
    }
     public function authorCommentedOnCount($userId){
        $count = 0;
        foreach($this->statsData as $key => $value)
        if($this->hasCommentsToCount($value, $userId) == true && $value['totalAuthorEngagement'] > 0) $count++;
        return $count;
    }
	public function getPostIdsAndUserIds(){
		$array = [];
		foreach($this->statsData as $key => $value) 
			$array[] = (object)['altUserId' => $value->altUserId, 'postId' => $value->postId, 'postTimestamp' => $value->postTimestamp];
		return $array;
	}
    public function getStats(){
        return $this->statsData;
    }
    public function getAdjustedStats(){
        $stats = [];
        foreach($this->statsData as $key => $value)
            if($value['actualPostTotalComments'] > 0) $stats[] = $value;
        return $stats;
    }
}
