<?php
namespace stats;
use \PDO;
use \DateTime;
class PrimaryBuzzwordsScores {
    private $groupNumber;
    private $group;
    private $statsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $db;
    function __construct($db, $groupNumber) {
        $this->db = $db;
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->statsTable = $this->group . '_posts_stats';
        $this->postsTable = $this->group . '_post_scores';
        $this->commentsTable = $this->group . '_comment_scores';
        $this->subCommentsTable = $this->group . '_sub_comment_scores';
    }
    public function getPostScores() {
        $sql = "SELECT 
		$this->postsTable.postId, 
		buzzwordCount, 
		buzzwords.buzzwordId, 
		relevantToAutism, 
		relevantToMentalHealth,
		specificToMe
		FROM $this->postsTable
		JOIN buzzwords ON buzzwords.buzzwordId = $this->postsTable.buzzwordId
		WHERE isPrimary = 1;";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getCommentScores() {
        $sql = "SELECT 
		$this->commentsTable.commentId, 
		buzzwordCount, 
		buzzwords.buzzwordId, 
		relevantToAutism, 
		relevantToMentalHealth,
		specificToMe
		FROM $this->commentsTable
		JOIN buzzwords ON buzzwords.buzzwordId = $this->commentsTable.buzzwordId 
		WHERE isPrimary = 1";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getSubCommentScores() {
        $sql = "SELECT 
		$this->subCommentsTable.subCommentId, 
		buzzwordCount, 
		buzzwords.buzzwordId, 
		relevantToAutism, 
		relevantToMentalHealth,
		specificToMe
		FROM $this->subCommentsTable
		JOIN buzzwords ON buzzwords.buzzwordId = $this->subCommentsTable.buzzwordId 
		WHERE isPrimary = 1";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

}
