<?php
namespace stats;
use \PDO;
use \DateTime;
use \extractors\PureText;
use \extractors\AnalysisText;
class SourceStatsForAnalysis{
    private $db;
    private $groupNumber;
    private $postsStatsTable;
    private $commentsStatsTable;
    private $subCommentsStatsTable;
    private $postComponentsTable;
    private $post;
    private $usersStatsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $usersTable;
    private $directory;
    private $postsData;
    private $postComponentsData;
    private $commentsData;
    private $subCommentsData;
    private $statsData;
    private $pureTextFile;
    private $analysisTextFile;
    private $dataArray = [];
   function __construct($db, $groupNumber) {
        $this->db = $db;
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->usersTable = $this->group . '_users';
        $this->postsTable = $this->group . '_posts';
        $this->commentsTable = $this->group . '_comments';
        $this->subCommentsTable = $this->group . '_sub_comments';
        $this->postComponentsTable = $this->group . '_post_components';
        $this->directory = getenv('BASE_URI') . '/data-cache';
        $this->pureTextFile = $this->group . "_source_text.txt";
        $this->analysisTextFile = $this->group . "_analysis_text.txt";
        $this->loadData();
    }
    private function loadData(){
        $this->loadCommentsData();
        $this->loadPostsComponentsData();
        $this->loadPostsData();
        $this->loadSubCommentsData();
    }
    public function loadPostsData(){
        $this->postsData = json_decode(file_get_contents($this->directory."/$this->postsTable.txt"),true);
    }
    public function loadPostsComponentsData(){
        $this->postComponentsData = json_decode(file_get_contents($this->directory."/$this->postComponentsTable.txt"),true);
    }
    public function loadCommentsData(){
        $this->commentsData = json_decode(file_get_contents($this->directory."/$this->commentsTable.txt"),true);
    }
    public function loadSubCommentsData(){
        $this->subCommentsData = json_decode(file_get_contents($this->directory."/$this->subCommentsTable.txt"),true);
    }
    public function getPostsText(){
        $arr = [];
        $i = 0;
        foreach($this->postComponentsData as $k => $value) if($value['category'] == 'text') {
        $arr[$i]['type'] = 'post'; 
        $arr[$i]['id'] = $value['postId'];
         $arr[$i]['altUserId'] = $value['altUserId'];
         $arr[$i]['text'] = $value['component'];
            $i++;
        }
        return $arr;
    }
    public function getCommentsText(){
        $arr = []; $i = 0;
        foreach($this->commentsData as $k => $value){
            $arr[$i]['type'] = 'comment'; 
            $arr[$i]['id'] = $value['commentId'];
            $arr[$i]['altUserId'] = $value['altUserId'];
            $arr[$i]['text'] = $value['commentMessage'];
            $i++;
        } 
        return $arr;
    }
      public function getSubCommentsText(){
        $arr = []; $i = 0;
        foreach($this->subCommentsData as $k => $value){
            $arr[$i]['type'] = 'subComment'; 
            $arr[$i]['id'] = $value['subCommentId'];
            $arr[$i]['altUserId'] = $value['altUserId'];
            $arr[$i]['text'] = $value['subCommentMessage'];
            $i++;
        } 
        return $arr;
    }
    public function createTextArray($textType){
        $vars = ['type','id','altUserId'];
        $arr = [];
        $i = 0;
        $textArray = $this->getPostsText($textType);
        foreach($textArray as $k => $v){
            $text = new $textType($v['text']);
            $text = $text->getResult();
            if(!empty($text)){
            $arr[$i]['text'] = $text;
            foreach($vars as $var)
                $arr[$i][$var] = $v[$var];
                $i++;
            }  
        }
        $textArray = $this->getCommentsText($textType);
        foreach($textArray as $k => $v){
            $text = new $textType($v['text']);
            $text = $text->getResult();
            if(!empty($text)){
            $arr[$i]['text'] = $text;
            foreach($vars as $var)
                $arr[$i][$var] = $v[$var];
                $i++;
            }   
        }
        $textArray = $this->getSubCommentsText($textType);
        foreach($textArray as $k => $v){
            $text = new $textType($v['text']);
            $text = $text->getResult();
            if(!empty($text)){
            $arr[$i]['text'] = $text;
            foreach($vars as $var)
                $arr[$i][$var] = $v[$var];
                $i++;
            }    
        }
        return $arr;
    }
    
    public function cacheSourceText(){
        $arr = $this->createTextArray("\\extractors\\PureText");
        $fp = file_put_contents($this->directory."/$this->pureTextFile", json_encode($arr,true));
    }
    public function cacheAnalysisText(){
        $textType = "\\extractors\\AnalysisText";
        $arr = $this->createTextArray($textType);
        $vars = ['post'=>'postId','comment'=>'commentId','subComment'=>'subCommentId'];
        foreach($arr as $k => $v)
            foreach($vars as $var => $id)
                if($v['type'] == $var) $arr[$k][$id] = $v['id'];
        $fp = file_put_contents($this->directory."/$this->analysisTextFile", json_encode($arr,true));
    }
    public function getAnalysisText(){
        $file = json_decode(file_get_contents($this->directory."/$this->analysisTextFile"),true);
        return $file;
    }
}
