<?php
namespace stats;
use \PDO;
class StartTimeOld {
    private $groupNumber;
    private $group;
    private $statsTable;
    private $db;
    function __construct($db, $groupNumber) {
        $this->db = $db;
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->statsTable = $this->group . '_users_stats';
    }
    public function getSelection($beg = false, $end = false) {
        $sql = "SELECT `timestamp`, firstActivity, userId FROM $this->statsTable WHERE (startTime = 0 OR startTime IS NULL) AND (`timestamp` > 0 || firstActivity > 0);";
        if ($end && $beg)  $sql.= " AND userId >= $beg AND userId < $end";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getStartTime($begin = false, $end = false) {
        $result = $this->getSelection($begin, $end);
        foreach ($result as $key => $value) {
            $userId = $value['userId'];
            $timestamp = $value['timestamp'];
            $first = $value['firstActivity'];
            if (is_null($timestamp) || $timestamp == 0) {
                $timestamp = $first;
                $sql = "UPDATE $this->statsTable SET startTime = $timestamp WHERE userId = $userId";
                $stmt = $this->db->query($sql);
            }
        }
    }
}
