<?php
namespace stats;
use \PDO;
use \DateTime;
class SubCommentPrimaryBuzzwords {
    private $groupNumber;
    private $group;
    private $statsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $db;
    function __construct($db, $groupNumber) {
        $this->db = $db;
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->statsTable = $this->group . '_posts_stats';
        $this->postsTable = $this->group . '_post_scores';
        $this->commentsTable = $this->group . '_comments';
        $this->subCommentsTable = $this->group . '_sub_comments';
    }
    public function getPrimaryScores() {
        $sql = "SELECT 
		$this->subCommentsTable.commentId, 
		buzzwordCount, 
		buzzwords.buzzwordId, 
		relevantToAutism, 
		relevantToMentalHealth 
		FROM $this->commentsTable
		JOIN buzzwords ON buzzwords.buzzwordId = $this->subCommentsTable.buzzwordId 
		WHERE isPrimary = 1";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getCommentScores() {
        $array = [];
        foreach ($this->getPrimaryScores() as $key => $value) {
            $vars = ['subCommentId', 'relevantToAutism', 'relevantToMentalHealth', 'buzzwordCount'];
            foreach ($vars as $var) ${$var} = $value[$var];
            $score = $relevantToMentalHealth - $relevantToAutism;
            $totalScore = $score * $buzzwordCount;
            $array[] = (object)['subCommentId' => $subCommentId, 'totalScore' => $totalScore];
        }
		return $array;
    }
}
