<?php
namespace stats;
use \PDO;
use \DateTime;
class SubCommentsCache {
    private $db;
    private $groupNumber;
    private $postsStatsTable;
    private $commentsStatsTable;
    private $subCommentsStatsTable;
    private $postComponentsTable;
    private $post;
    private $usersStatsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $directory = 'data-cache';
    private $statsData;
   function __construct($groupNumber) {
        
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->usersStatsTable = $this->group . '_users_stats';
        $this->postsStatsTable = $this->group . '_posts_stats';
        $this->commentsStatsTable = $this->group . '_comments_stats';
        $this->subCommentsStatsTable = $this->group . '_sub_comments_stats';
        $this->subCommentsTable = $this->group . '_sub_comments';
        $this->postComponentsTable = $this->group . '_post_components';
        $this->directory = getenv('BASE_URI') . '/data-cache'; 
        $this->loadData();
    }
    private function loadData(){
        $this->subCommentsData = json_decode(file_get_contents($this->directory."/$this->subCommentsTable.txt"));
    }
    public function subCommentsByCommentId($commentId){
        $count = 0;
         $comments = [];
         ///$comments[$postId] = [];
        foreach($this->subCommentsData as $key => $value) 
        if($value->commentId == $commentId && $value->processed == 0 && $value->emptySubComment == 0) $comments[] = (object)['subCommentMessage' => $value->subCommentMessage, 'subCommentId' => $value->subCommentId, 'userId' => $value->userId];
        return $comments;
    }
    public function commentIdsInSubComments($processed = 0){
        $count = 0;
        $comments = [];
        foreach($this->subCommentsData as $key => $value) 
        if($value->emptySubComment == 0 && $value->processed == $processed) $comments[] =  $value->commentId;
        $comments = array_unique($comments);
        return $comments;
    }
    public function subCommentCountByPostId($postId){
        $count = 0;
        foreach($this->statsData as $key => $value) if($value['postId']==$postId) $count++;
        return $count;
    }
    public function subCommentCountByPostAndUserId($postId,$userId){
        $count = 0;
        foreach($this->statsData as $key => $value) 
            if($value['postId']==$postId && $value['altUserId'] == $userId) $count++;
        return $count;
    }
     public function subCommentCountByUserId($userId){
        $count = 0;
        foreach($this->statsData as $key => $value) 
            if($value['altUserId'] == $userId) $count++;
        return $count;
    }
    public function didUserComment($postId,$userId){
        foreach($this->statsData as $key => $value) 
            if($value['postId']==$postId && $value['altUserId'] == $userId) return 1;
    }
    public function totalByUserId($userId, $itemToGet){
        $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['altUserId'] == $userId) $count += $value[$itemToGet];
        return $count;
    }
    public function getStatsData(){
        return $this->statsData;
    }
	
}
