<?php
namespace stats;
use \PDO;
use \DateTime;
use \extractors\SubCommentTimestamp;
class SubCommentsTimeUpdate {
    private $groupNumber;
    private $group;
    private $statsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $db;
    function __construct($db, $groupNumber) {
        $this->db = $db;
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->statsTable = $this->group . '_users_stats';
        $this->postsTable = $this->group . '_posts';
        $this->commentsTable = $this->group . '_comments';
        $this->subCommentsTable = $this->group . '_sub_comments';
    }
    public function updateTimestamps($begin = false, $end = false) {
        $result = $this->getSubCommentsToBeUpdated();
        $vars = ['fileModified', 'subCommentDate', 'subCommentId'];
        foreach ($result as $key => $value) {
            foreach ($vars as $var) ${$var} = $value[$var];
            if (!$subCommentDate) continue;
            $stamp = new SubCommentTimestamp($fileModified, $subCommentDate);
            $stamp = $stamp->getResult();
            $sql = "UPDATE $this->subCommentsTable SET subCommentTimestamp = $stamp WHERE subCommentId = $subCommentId";
            $stmt = $this->db->prepare($sql);
            $stmt->execute();
        }
    }
    public function getSubCommentsToBeUpdated() {
        $sql = "SELECT fileModified, 
		subCommentId, 
		subCommentDate 
		FROM $this->subCommentsTable 
		JOIN $this->commentsTable ON $this->commentsTable.commentId = $this->subCommentsTable.commentId
		JOIN $this->postsTable ON $this->commentsTable.postId = $this->postsTable.postId 
		WHERE subCommentTimestamp IS NULL OR subCommentTimestamp = 0";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
