<?php
namespace stats;
use \PDO;
use \DateTime;
class TableUsersRangeStats {
    private $db;
    private $table;
    function __construct($db) {
        $this->db = $db;
    }
	public function setTable($table){
		$this->table = $table;
	}
	public function getTimestampArray(){
		$sql = "SELECT startTime FROM $this->table WHERE startTime != 0 ORDER BY startTime DESC";
		$stmt = $this->db->query($sql);
		$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
		$array = [];
		return $result;
	}
	public function getEarliestUser(){
		$result = $this->getTimestampArray();
		return end($result)['startTime'];
	}
	public function getLatestUser(){
		$result = $this->getTimestampArray();
		return $result[0]['startTime'];
	}
    
}
