<?php
namespace stats;
use \PDO;
use \DateTime;
class UsersStats {
    private $db;
    private $groupNumber;
    private $postsStatsTable;
    private $commentsStatsTable;
    private $subCommentsStatsTable;
    private $postComponentsTable;
    private $post;
    private $usersStatsTable;
    private $postsTable;
    private $commentsTable;
    private $subCommentsTable;
    private $directory = 'data-cache';
    private $statsData;
	private $group;
   function __construct($groupNumber) {
        $this->groupNumber = $groupNumber;
        $this->group = 'group_' . $this->groupNumber;
        $this->usersStatsTable = $this->group . '_users_stats';
        $this->postsStatsTable = $this->group . '_posts_stats';
        $this->commentsStatsTable = $this->group . '_comments_stats';
        $this->subCommentsStatsTable = $this->group . '_sub_comments_stats';
        $this->postComponentsTable = $this->group . '_post_components';
        $this->directory = getenv('BASE_URI') . '/data-cache'; 
        $this->loadData();
    }
    private function loadData(){
        $this->statsData = json_decode(file_get_contents($this->directory."/$this->usersStatsTable.txt"),true);
    }
    public function getStats(){
        return $this->statsData;
    }
    public function usersByTimeInterval($beg, $end){
        $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['startTime'] >= $beg && $value['startTime'] <= $end) $count++;
        return $count;
    }
    public function cumulativeUsersByTime($end){
        $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['startTime'] <= $end) $count++;
        return $count;
    }
    public function totalByTimePeriod($item, $beg, $end){
         $count = 0;
        foreach($this->statsData as $key => $value)
          if($value['startTime'] >= $beg && $value['startTime'] <= $end) 
            $count += $value[$item];
        return $count;
    }
    public function usersWithPosts($beg, $end){
         $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['startTime'] >= $beg && $value['startTime'] <= $end && $value['userPostCount'] > 0) $count++;
        return $count;
    }
    public function getUsersWithPosts(){
         $array = [];
        foreach($this->statsData as $key => $value)
            if($value['userPostCount']) $array[] = $value;
        return $array;
    }
    public function usersWithComments($beg, $end){
         $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['startTime'] >= $beg && $value['startTime'] <= $end && $value['userCommentCount'] > 0) $count++;
        return $count;
    }
    public function usersWithSubComments($beg, $end){
         $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['startTime'] >= $beg && $value['startTime'] <= $end && $value['userSubCommentCount'] > 0) $count++;
        return $count;
    }
    public function usersWhoCommented($beg, $end){
         $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['startTime'] >= $beg && $value['startTime'] <= $end 
            && (($value['userSubCommentCount'] + $value['userCommentCount']) > 0 )) $count++;
        return $count;
    }
    public function usersWithActivity($beg, $end){
         $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['startTime'] >= $beg && $value['startTime'] <= $end 
            && (($value['userSubCommentCount'] + $value['userCommentCount'] + $value['userPostCount']) > 0 )) $count++;
        return $count;
    }
	
	 public function userStartTimeByUserId($userId){
         $count = 0;
        foreach($this->statsData as $key => $value)
            if($value['userId'] !== $userId) continue;
		    else return (object)['startTime' => $value['startTime'], 'timestamp' => $value['timestamp']];
    }
    
	
}
