<?php
namespace stats;
use \PDO;
use \DateTime;
class UsersSubCommentCount {
    private $db;
    private $sql;
    private $cutOffTime;
    private $result;
    private $startTime;
    private $endTime;
    function __construct($db) {
        $this->db = $db;
       
    }
    public function setCutOffTime($time){
        $this->cutOffTime = $time;
    }
    public function setStartTime($time){
        $this->startTime = $time;
    }
    public function setEndTime($time){
        $this->endTime = $time;
    }
   public function getTimestamp($time,$hms = [0,0,0]){
        if(strpos($time,'/')===false) return $time;
        $timeArray = explode('/',$time);
        $date = new DateTime;
        $date->setDate($timeArray[2],$timeArray[0],$timeArray[1]);
        $date->setTime($hms[0],$hms[1],$hms[2]);
        return $date->getTimestamp();
    }
    public function getStartAndEnd(){
        $sql = '';
        if(isset($this->startTime)) $sql .= " AND startTime >= ".$this->getTimestamp($this->startTime);
        if(isset($this->endTime)) $sql .= " AND startTime <= ".$this->getTimestamp($this->endTime,[23,59,59]);
        return $sql;
    }
    public function getSql(){
        $this->sql = "SELECT postScore, commentScore, `timestamp`, postTextCount, firstActivity, postCount, commentCount, subCommentCount, subCommentScore, startTime FROM group_4_users_stats WHERE subCommentCount > 0";
        $this->sql .= $this->getStartAndEnd();
        return $this->sql;
    }
    public function getQueryResult(){
        if(!$this->result){
        $this->getSql();
        $stmt = $this->db->query($this->sql);
        $this->result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
        return $this->result;
    }
    public function calculateScore(){
        $this->getQueryResult();
        $score = 0;
        foreach($this->result as $key => $value) $score+= $value['subCommentCount'];
        return $score;
    }
    public function calculateCount(){
        $this->getQueryResult();
        $count = 0;
        foreach($this->result as $key => $value) $count+= $value['subCommentCount'];
        return $count;
    }
    public function calculateUserCount(){
        $this->getQueryResult();
        return count($this->result);
    }
    public function calculateAverageScore(){
        return $this->calculateScore()/$this->calculateCount();
    }
      public function calculateUserScore(){
        return $this->calculateScore()/$this->calculateUserCount();
    }
    
	
}
