<?php
include_once getenv('BASE_URI') . '/includes/config.php';
include_once getenv('BASE_URI') . '/includes/init.php';
include_once getenv('BASE_URI') . '/htmlArray.php';
include_once getenv('BASE_URI') . '/includes/group_number.php';
use stats\TotalBuzzwordsScores;
use stats\BipolarBuzzwordsScores;
use stats\BuzzwordsScore;
use stats\SpecificBuzzwordsScores;
use stats\NotSpecificBuzzwordsScores;
use stats\LessSpecificBuzzwordsScores;
use stats\ScoreUpdate;

$start = new DateTime;
$start = $start->getTimestamp();
$groups = [1,2,4,6];
foreach($groups as $group){
$groupNumber = $group;
$postsStatsTable = 'group_'.$group.'_posts_stats';
$commentsStatsTable = 'group_'.$group.'_comments_stats';
$subCommentsStatsTable = 'group_'.$group.'_sub_comments_stats';

/* start sub comments */

/* less specific */

$dbColumn = 'subCommentsLessSpecificBuzzwordsScore';
$sql = "UPDATE $subCommentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new LessSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getSubCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToSubCommentScore($score->totalScore, $score->subCommentId, $dbColumn);

/* specfic */


/* less specific */

$dbColumn = 'commentsLessSpecificBuzzwordsScore';
$sql = "UPDATE $commentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new LessSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToCommentScore($score->totalScore, $score->commentId, $dbColumn);

/* less specific */

$dbColumn = 'postsLessSpecificBuzzwordsScore';
$sql = "UPDATE $postsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new LessSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getPostScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToPostScore($score->totalScore, $score->postId, $dbColumn);

/* bipolar */

$dbColumn = 'commentsBipolarBuzzwordsScore';
$sql = "UPDATE $commentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new BipolarBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToCommentScore($score->totalScore, $score->commentId, $dbColumn);

/* bipolar */

$dbColumn = 'subCommentsBipolarBuzzwordsScore';
$sql = "UPDATE $subCommentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new BipolarBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getSubCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToSubCommentScore($score->totalScore, $score->subCommentId, $dbColumn);

/* bipolar */

$dbColumn = 'postsBipolarBuzzwordsScore';
$sql = "UPDATE $postsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new BipolarBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);
$scores = $buzz->getPostScores($total);
$update = new ScoreUpdate($db, $groupNumber);

foreach($scores as $key => $score)
	$update->addToPostScore($score->totalScore, $score->postId, $dbColumn);
    
}
$minutes = ($end - $start)/60;
newLine("$minutes minutes to complete");
?>