<?php
include_once getenv('BASE_URI') . '/includes/config.php';
include_once getenv('BASE_URI') . '/includes/init.php';
include_once getenv('BASE_URI') . '/htmlArray.php';
include_once getenv('BASE_URI') . '/includes/group_number.php';
use stats\TotalBuzzwordsScores;
use stats\BipolarBuzzwordsScores;
use stats\BuzzwordsScore;
use stats\SpecificBuzzwordsScores;
use stats\NotSpecificBuzzwordsScores;
use stats\LessSpecificBuzzwordsScores;
use stats\ScoreUpdate;

$start = new DateTime;
$start = $start->getTimestamp();

$groupNumber = $group;
$postsStatsTable = 'group_'.$group.'_posts_stats';
$commentsStatsTable = 'group_'.$group.'_comments_stats';
$subCommentsStatsTable = 'group_'.$group.'_sub_comments_stats';

/* start sub comments */

/* not specific */
$specificToMeMultiplier = 3;
$dbColumn = 'subCommentsNotSpecificBuzzwordsScore';
$sql = "UPDATE $subCommentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new NotSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getSubCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToSubCommentScore($score->totalScore, $score->subCommentId, $dbColumn);

/* specfic */

$dbColumn = 'subCommentsSpecificBuzzwordsScore';
$sql = "UPDATE $subCommentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new SpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getSubCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToSubCommentScore($score->totalScore, $score->subCommentId, $dbColumn);

/* less specfic */

$dbColumn = 'subCommentsLessSpecificBuzzwordsScore';
$sql = "UPDATE $subCommentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new LessSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getSubCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToSubCommentScore($score->totalScore, $score->subCommentId, $dbColumn);

/* bipolar */

$dbColumn = 'subCommentsBipolarBuzzwordsScore';
$sql = "UPDATE $subCommentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new BipolarBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getSubCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToSubCommentScore($score->totalScore, $score->subCommentId, $dbColumn);

/* total */ 

$dbColumn = 'subCommentsTotalBuzzwordsScore';
$sql = "UPDATE $subCommentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new TotalBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getSubCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToSubCommentScore($score->totalScore, $score->subCommentId, $dbColumn);

/* end sub comments */

/* start comments */

/* not specific */

$dbColumn = 'commentsNotSpecificBuzzwordsScore';
$sql = "UPDATE $commentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new NotSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToCommentScore($score->totalScore, $score->commentId, $dbColumn);

/* specific */

$dbColumn = 'commentsSpecificBuzzwordsScore';
$sql = "UPDATE $commentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new SpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToCommentScore($score->totalScore, $score->commentId, $dbColumn);

/* less specfic */

$dbColumn = 'commentsLessSpecificBuzzwordsScore';
$sql = "UPDATE $commentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new LessSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToCommentScore($score->totalScore, $score->commentId, $dbColumn);

/* bipolar */

$dbColumn = 'commentsBipolarBuzzwordsScore';
$sql = "UPDATE $commentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new BipolarBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToCommentScore($score->totalScore, $score->commentId, $dbColumn);

/* total */

$dbColumn = 'commentsTotalBuzzwordsScore';
$sql = "UPDATE $commentsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new TotalBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);

$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getCommentScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToCommentScore($score->totalScore, $score->commentId, $dbColumn);

/* end comments */

/*start posts */

/* not specific */

$dbColumn = 'postsNotSpecificBuzzwordsScore';
$sql = "UPDATE $postsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new NotSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getPostScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToPostScore($score->totalScore, $score->postId, $dbColumn);

/* specific */

$dbColumn = 'postsSpecificBuzzwordsScore';
$sql = "UPDATE $postsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new SpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getPostScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToPostScore($score->totalScore, $score->postId, $dbColumn);

/* less specific */

$dbColumn = 'postsLessSpecificBuzzwordsScore';
$sql = "UPDATE $postsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new LessSpecificBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);

$scores = $buzz->getPostScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToPostScore($score->totalScore, $score->postId, $dbColumn);

/* bipolar */

$dbColumn = 'postsBipolarBuzzwordsScore';
$sql = "UPDATE $postsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new BipolarBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);
$scores = $buzz->getPostScores($total);
$update = new ScoreUpdate($db, $groupNumber);

foreach($scores as $key => $score)
	$update->addToPostScore($score->totalScore, $score->postId, $dbColumn);

/* total */

$dbColumn = 'postsTotalBuzzwordsScore';
$sql = "UPDATE $postsStatsTable SET $dbColumn = 0;";
$db->query($sql);
$total = new TotalBuzzwordsScores($db, $groupNumber);
$buzz = new BuzzwordsScore($db,$groupNumber);
$buzz->setSpecificToMeMultiplier($specificToMeMultiplier);
$scores = $buzz->getPostScores($total);
$update = new ScoreUpdate($db, $groupNumber);
foreach($scores as $key => $score)
	$update->addToPostScore($score->totalScore, $score->postId, $dbColumn);
/* end posts */

$end = new DateTime;
$end = $end->getTimestamp();
 
$minutes = ($end - $start)/60;
newLine("$minutes minutes to complete");
?>